require( "scripts/style.lua" );

TitleFont = {
  standardFont,
  64,
  BlackColor
};

VersionFont = {
  standardFont,
  20,
  BlackColor
};


MakeDialog
{
	-- Name the modal dialog
	name="creditswindow",
	Bitmap
	{
		image="backgrounds/fullscreendialog",

		Text
		{
			font = TitleFont,
			name = "title",
			x=kCenter,y=25,w=kMax ,h=75,
			flags = kHAlignCenter + kVAlignTop,
			label = "credits"
		};

		CreditsWindow
		{
			x = 20, y = 110,
			w = 710, h = 386,
			font = standardFont,
			fontsize = 16,
			fontcolor = BlackColor,
			headercolor = BlueColor,
			columngap = 50,
			columnwidth = 300,
			time = 20000, 		-- Time to play credits in milliseconds
			intropause = 4000, 	-- Time to pause credits at start, in ms
			file = "credits/credits.txt",
		},

		Text
		{
			font = VersionFont,
			flags=kHAlignCenter + kVAlignTop,
			x=0,y=kMax-40,
			w=kMax;h=75;
			label="#"..GetString("version",GetConfig(kGameVersion));
		};

		Button
		{
			x=kCenter,
			y=kMax-80,
			graphics= vHSButtonGraphics,
			font	= vHSButtonFontStyle,
			name="back",
			type = kPush,
			flags = kHAlignCenter + kVAlignCenter,
			label="back",
			command =
				function()
					PopModal("creditswindow");
				end
		};
	},
}